package application;

import java.util.Scanner;

public class Menu {
    private final Scanner scanner = new Scanner(System.in);

    public int selectOption(String option, int min, int max) {
        while (true) {
            System.out.print(option + " (" + min + " и " + max + "): ");
            try {
                int choice = Integer.parseInt(scanner.nextLine());
                if (choice >= min || choice <= max)
                    return choice;
            } catch (Exception e) {
                System.out.println(" Ввести нужно число от  " + min + " до " + max);
            }
            System.out.println("Неверный ввод. Повторите попытку!");
        }
    }

    public boolean confirm(String option) {
        System.out.print(option + "(Y/N): ");
        return scanner.nextLine().trim().equalsIgnoreCase("Y");
    }
}
