package application;

import model.Product;

import java.util.Scanner;

public class ProductCreator {
    private final Scanner scanner = new Scanner(System.in);

    public Product createProduct() {
        double price = -1;
        System.out.print("ID: ");
        String id = scanner.nextLine();
        System.out.print("Название: ");
        String name = scanner.nextLine();
        while (name.isBlank()) {
            System.out.print("Название: ");
            name = scanner.nextLine().trim();
            if (name.isBlank()) {
                System.out.println("Название не может быть пустым.");
            }
        }
        while (price < 0) {
            System.out.print("Цена (неотрицательная): ");
            try {
                price = Double.parseDouble(scanner.nextLine());
                if (price < 0) {
                    System.out.println("Цена не может быть отрицательной.");
                }
            } catch (NumberFormatException e) {
                System.out.println("Введите корректное число.");
            }
        }
        return new Product(id, name, price);
    }
}
