package model;

import com.google.gson.annotations.SerializedName;
import models.ProductState;
import models.StockState;

public class Product {
    private String id;
    private String name;
    private double price;
    @SerializedName("init_price")
    private double initPrice;
    private ProductState state;
    @SerializedName("honorary_code")
    private String honoraryCode;

    public Product(String id, String name, double price) {
        this.id = id;
        this.name = name;
        this.initPrice = price;
        this.price = price;
        this.state = new StockState();
    }

    public Product() {
    }

    public String getId() {
        return id;
    }

    public double getInitPrice() {
        return initPrice;
    }
    public void setInitPrice(double initPrice) {
        this.initPrice = initPrice;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public ProductState getState() {
        return state;
    }

    public void setState(ProductState state) {
        this.state = state;
    }

    public String getHonoraryCode() {
        return honoraryCode;
    }

    public void setHonoraryCode(String honoraryCode) {
        this.honoraryCode = honoraryCode;
    }

    @Override
    public String toString() {
        return String.format("%-10s | %-25s | %10.2f | %-15s | %s", id, name, price, state.getTitle(), honoraryCode);
    }

    public void startSale(){
        state.startSale(this);
    }

    public void raisePrice(){
        state.raisePrice(this);
    }

    public void withdraw(){
        state.withdraw(this);
    }

    public void giveToWinner(){
        state.giveToWinner(this);
    }

}
