package models;

import model.Product;

public abstract class ProductState {
    private final String title;

    protected ProductState(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public abstract void startSale(Product product);
    public abstract void raisePrice(Product product);
    public abstract void withdraw(Product product);
    public abstract void giveToWinner(Product product);
}
