package models;

import services.CodeGenerator;
import model.Product;

public class SaleState extends ProductState {
    public SaleState() {
        super("for_sale");
    }

    @Override
    public void giveToWinner(Product product) {
        if(product.getPrice()==0) {
            System.out.println("Ошибка: Нельзя отдать товар бесплатно");
            return;
        }
        product.setState(new SoldState());
        product.setHonoraryCode(CodeGenerator.generateHonoraryCode(product));
        System.out.println("Товар продан.");
    }

    @Override
    public void raisePrice(Product product) {
        product.setPrice(product.getPrice() + 100);
        System.out.println("Цена лота увеличена до: " + product.getPrice());
    }

    @Override
    public void startSale(Product product) {
        System.out.println("Ошибка: Товар уже на аукционе!");
    }

    @Override
    public void withdraw(Product product) {
        if (product.getPrice() == product.getInitPrice()) {
            product.setState(new StockState());
            System.out.println("Товар возвращен на склад!");
        }else{
            System.out.println("Ошибка: Товар уже в резерве!");
        }
    }
}
