package repositories;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import application.utils.FileReader;
import application.utils.FileWriter;
import model.Product;
import models.ProductCollection;
import models.ProductState;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ProductRepository {
    private final Gson gson = new GsonBuilder()
            .registerTypeAdapter(ProductState.class, new ProductStateDeserialize())
            .registerTypeAdapter(ProductState.class, new ProductStateSerialize())
            .setPrettyPrinting()
            .create();

    private final String path;
    private final FileReader fileReader = new FileReader();
    private final FileWriter fileWriter = new FileWriter();

    public ProductRepository(String filePath) {
        this.path = filePath;
    }

    public ProductCollection getGoods() {
        try {
            Path filePath = Paths.get(path);
            if (!Files.exists(filePath)) return new ProductCollection();
            String json = fileReader.read(path);
            if (json.isBlank()) return new ProductCollection();
            Product[] products = gson.fromJson(json, Product[].class);
            return convertToCollection(products);
        } catch (IOException e) {
            e.printStackTrace();
            return new ProductCollection();
        }
    }

    public void save(ProductCollection collection) {
        try {
            Product[] raw = collection.getAllProducts();
            Product[] prepared = new Product[raw.length];

            for (int i = 0; i < raw.length; i++) {
                Product original = raw[i];
                Product clone = new Product();
                clone.setId(original.getId());
                clone.setName(original.getName());
                clone.setPrice(original.getPrice());
                clone.setInitPrice(original.getInitPrice());
                clone.setHonoraryCode(original.getHonoraryCode());
                clone.setState(original.getState());
                prepared[i] = clone;
            }

            String json = gson.toJson(prepared);
            fileWriter.write(path, json);
        } catch (IOException e) {
            System.out.println("Ошибка записи: " + e.getMessage());
        }
    }

    private ProductCollection convertToCollection(Product[] products) {
        ProductCollection collection = new ProductCollection();
        if (products != null) {
            for (Product p : products) {
                if (p.getPrice() == 0 && p.getInitPrice() > 0) {
                    p.setPrice(p.getInitPrice());
                }
                collection.add(p);
            }
        }
        return collection;
    }
}
