package repositories;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import models.SaleState;
import models.ProductState;
import models.SoldState;
import models.StockState;

import java.lang.reflect.Type;

public class ProductStateDeserialize implements JsonDeserializer<ProductState> {
    public ProductState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
            throws JsonParseException {
        String type = json.getAsString();
        switch (type){
            case "for_sale":
                return new SaleState();
            case "in_stock":
                return new StockState();
            case "sold":
                return new SoldState();
            default:
                throw new JsonParseException("Unknown state type: " + type);
        }
    }
}
