package services;

import model.Product;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CodeGenerator {
    public static String generateHonoraryCode(Product p) {
        CodeStrategy strategy;
        double price = p.getPrice();
        if (price >= 1000) {
            strategy = new GoldCodeStrategy();
        } else if (price >= 500) {
            strategy = new SilverCodeStrategy();
        } else {
            strategy = new BronzeCodeStrategy();
        }
        return strategy.generate(p.getId());
    }

    public static String makeCode(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(input.getBytes());
            return convertToString(digest);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String convertToString(byte[] array) {
        return IntStream.range(0, array.length)
                .map(i -> array[i] < 0 ? array[i] + 256 : array[i])
                .mapToObj(Integer::toHexString)
                .collect(Collectors.joining());
    }
}
