package application;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import model.Product;
import models.ProductCollection;
import repositories.ProductRepository;

import java.io.IOException;
import java.util.Scanner;

public class Auction {
    private final Menu menu = new Menu();
    private final ProductCreator creator = new ProductCreator();
    private ProductCollection collection;
    private ProductRepository repository;

    private Scanner scanner = new Scanner(System.in);

    public Auction(ProductCollection collection, ProductRepository repository) {
        this.collection = collection;
        this.repository = repository;
    }

    public void start() {
        while (true) {
            printProducts();
            System.out.println("0. Добавить новый товар");
            System.out.println();
            int choice = menu.selectOption("Выберите товар или 0 для добавления нового товара: ", 0, collection.size());

            if (choice == 0) {
                Product newProduct = creator.createProduct();
                collection.add(newProduct);
                repository.save(collection);
                continue;
            }
            if (choice < 1 || choice > collection.size()) {
                System.out.println("неверный номер товара");
                continue;
            }

            Product product = collection.get(choice - 1);
            boolean back = false;
            while (!back) {
                System.out.println("\n" + product);
                System.out.println("1. Выставить на аукцион");
                System.out.println("2. Поднять цену");
                System.out.println("3. Выдать победителю");
                System.out.println("4. Снять с аукциона");
                System.out.println("5. Отобразить инфо по товару");
                System.out.println("6. Вернуться в список товаров");

                switch (menu.selectOption("Что Вы хотите сделать (введите номер)", 1, 6)) {
                    case 1:
                        product.startSale();
                        break;
                    case 2:
                        product.raisePrice();
                        break;
                    case 3:
                        product.giveToWinner();
                        break;
                    case 4:
                        product.withdraw();
                        break;
                    case 5:
                        product.toString();
                        break;
                    case 6:
                        back = true;
                }
                repository.save(collection);
            }
            if (!menu.confirm("Продолжить аукцион?")) {
                saveReport();
                break;
            }
        }
    }

    private void printProducts() {
        System.out.println("\n Список товаров:");
        System.out.printf("%-4s | %-10s | %-25s | %-10s | %-15s | %s\n",
                "#", "ID", "Название", "Цена", "Состояние", "Почетный код");
        System.out.println("-----------------------------------------------------------------------------------");
        for (int i = 0; i < collection.size(); i++) {
            Product p = collection.get(i);
            System.out.printf("%-4d | %-10s | %-25s | %-10.2f | %-15s | %s\n",
                    i + 1, p.getId(), p.getName(), p.getPrice(), p.getState().getTitle(),
                    p.getHonoraryCode());
        }
    }

    private void saveReport() {
        Product[] products = collection.getAllProducts();

        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        application.utils.FileWriter writer = new application.utils.FileWriter();
        try {
            Product[] snapshot = new Product[products.length];
            for (int i = 0; i < products.length; i++) {
                Product p = products[i];
                Product clone = new Product();
                clone.setId(p.getId());
                clone.setName(p.getName());
                clone.setPrice(p.getPrice());
                clone.setInitPrice(p.getInitPrice());
                clone.setHonoraryCode(p.getHonoraryCode());
                clone.setState(p.getState());
                snapshot[i] = clone;
            }
            writer.write("resources/products_after_auction.json", gson.toJson(snapshot));
        } catch (IOException e) {
            System.out.println("Ошибка при сохранении полного списка: " + e.getMessage());
        }
    }

}

