package models;

import model.Product;

public class SoldState extends State {

    public SoldState() {
        super("sold");
    }

    @Override
    public void giveToWinner(Product product) {
        System.out.println("Ошибка: Товар уже выдан");
    }

    @Override
    public void raisePrice(Product product) {
        System.out.println("Ошибка: Нельзя повысить цену! Товар продан");
    }

    @Override
    public void startSale(Product product) {
        System.out.println("Ошибка: Товар уже продан");
    }

    @Override
    public void withdraw(Product product) {
        System.out.println("Ошибка: Нельзя снять с аукциона! Товар продан");
    }
}
