package models;

import model.Product;

public class StockState extends State {
    public StockState() {
        super("in_stock");
    }

    @Override
    public void giveToWinner(Product product) {
        System.out.println("Ошибка: Нельзя отдать товар со склада!");
    }

    @Override
    public void raisePrice(Product product) {
        System.out.println("Ошибка: Нельзя поднять цену. Товар не на аукционе!");
    }

    @Override
    public void startSale(Product product) {
        product.setState(new SaleState());
        System.out.println("Товар выставлен на аукцион!");
    }

    @Override
    public void withdraw(Product product) {
        System.out.println("Ошибка: Нельзя снять с аукциона: товар не на торгах!");
    }
}
