'use client'

import { ChangeEvent, useState } from 'react'
import RadioGroup from '../UI/RadioGroup/RadioGroup'
import styles from './Bill.module.css'
import { EPaymentType } from '@/enums/EPaymentType'
import { eqInputArray, spInputArray, Input } from './inputs'
import InputBlock from '../UI/InputBlock/InputBlock'
import SeparatePeople from '../SeparatePeople/SeparatePeople'

const Bill = () => {
    const [paymentType, setPaymentType] = useState<EPaymentType | null>(null)
    const [state, setState] = useState<{
        amount: number
        sum: number
        tips: number
        delivery: number
    }>({
        amount: 0,
        sum: 0,
        tips: 0,
        delivery: 0
    })

    const [isCalculated, setIsCalculated] = useState<boolean>(false)

    const [people, setPeople] = useState<{
        [id: string]: {name: string, sum: string}
    }>({})

    const renderInputs = () => {
        if (!paymentType) return
        const arr = paymentType === EPaymentType.EQUALY ? eqInputArray : spInputArray
        return arr.map((input: Input) => {
            return (
                <InputBlock 
                    key={input.name}
                    ext={input.ext}
                    label={input.label}
                    value={state[input.name as keyof typeof state].toString()}
                    name={input.name}
                    onChange={inputOnChangeHandler}
                />
            )
        })
    }

    const radioOnChangeHandler = (e: ChangeEvent<HTMLInputElement>) => {
        setPaymentType(e.target.value as EPaymentType)
    }

    const inputOnChangeHandler = (e: ChangeEvent<HTMLInputElement>) => {
        setState(prevState => {
            return {...prevState, [e.target.name]: e.target.value}
        })
    }
    const calculateHandler = () => {
        setIsCalculated(true)
    }

    const calculate = (): React.ReactNode => {
        if (paymentType === EPaymentType.EQUALY) {
            const sum = Number(state.sum) + Number(state.delivery) + Math.ceil((Number(state.sum) * Number(state.tips) / 100))
            return (
                <div>
                    <p>SUM: {sum} tenge</p>
                    <p>PEOPLE: {state.amount} person</p>
                    <p>EACH PAYS: {Math.ceil(sum / state.amount)}</p>
                </div>
            )
        } else if (paymentType === EPaymentType.SEPARATELY) {
            let sum = 0
            const peopleAmount = Object.keys(people).length
            const peopleArray: React.ReactNode = Object.keys(people).map(id => {
                const p = people[id as keyof typeof people]
                const tempSum = Math.ceil(Number(p.sum) + Math.ceil(state.delivery / peopleAmount)) + Math.ceil((Number(p.sum) * Number(state.tips) / 100))
                sum += tempSum
                return <p key={id}>{p.name} : {tempSum}</p>
            })
            
            return (
                <div>
                    <p>SUM: {sum} tenge</p>
                    <p>PEOPLE: {peopleAmount} person</p>
                    {peopleArray}
                </div>
            )
        }

        return null
    }

    const peopleOnChangeHandler = (e: ChangeEvent<HTMLInputElement>, id: number) => {
        setPeople((prevState) => {
            return {
                ...prevState, 
                [id]: {
                    ...prevState[id], 
                    [e.target.name]: e.target.value
                }
            }
        })
    }

    return (
        <div className={styles.Bill}>
            <RadioGroup 
                name={'payment_type'}
                onChange={radioOnChangeHandler}
                title='Bill counts as:'
                radioGroup={[
                    {
                        label: 'Equaly',
                        value: EPaymentType.EQUALY,
                    },
                    {
                        label: 'Separately',
                        value: EPaymentType.SEPARATELY,
                    },
                ]}
            />
            {paymentType === EPaymentType.SEPARATELY ? <SeparatePeople 
                onChange={(e, id) => {peopleOnChangeHandler(e, id)}}
                deletePeople={(id) => {
                    setPeople(prevState => {
                        delete prevState[id]
                        return {...prevState}
                    })
                }}
            /> : null}
            {renderInputs()}

            {paymentType ? <button onClick={calculateHandler}>Calculate</button> : null}
            {isCalculated ? calculate() : null}
        </div>
    )
}

export default Bill