'use client'
import { ChangeEvent, ChangeEventHandler, useState } from "react"
import SeparateInput from "./SeparateInput"

type Props = {
    onChange: (e: ChangeEvent<HTMLInputElement>, id: number) => void
    deletePeople: (id: number) => void
}

const SeparatePeople = ({onChange, deletePeople}: Props) => {
    const [people, setPeople] = useState<{
        id: number,
        name: string,
        sum: string
    }[]>([])
    const deleteHandler = (id: number) => {
        const copyState = [...people]
        const filteredState = copyState.filter(p => p.id !== id)
        setPeople(filteredState)
        deletePeople(id)
    }

    const addPeople = () => {
        setPeople((prevState) => {
            return [...prevState, {
                id: Math.random(),
                name: '',
                sum: ''
            }]
        })
    }

    return (
        <>
            {people.map((p) => {
                return (
                    <SeparateInput 
                        key={p.id}
                        onChange={(e) => onChange(e, p.id)}
                        onClick={deleteHandler}
                        id={p.id}
                    />
                )
            })}
            <button onClick={addPeople}>+</button>
        </>
    )
}

export default SeparatePeople