import { ChangeEventHandler } from 'react'
import styles from './InputBlock.module.css'

type Props = {
    value: string
    label: string
    name: string
    ext: string
    onChange: ChangeEventHandler<HTMLInputElement>
}

const InputBlock = ({value, label, name, ext, onChange}: Props) => {
    return (
        <div>
            <span className={styles.InputBlockLabel}>{label}</span>
            <input type="text" name={name} value={value} onChange={onChange} />
            <span>{ext}</span>
        </div>
    )
}

export default InputBlock