'use client'

import { TRadioGroupItem } from '@/types/TRadioGroupItem'
import styles from './RadioGroup.module.css'
import { ChangeEventHandler } from 'react'

type Props = {
    title: string
    name: string
    radioGroup: TRadioGroupItem[]
    onChange: ChangeEventHandler<HTMLInputElement>
}

const RadioGroup = ({title, name, radioGroup, onChange}: Props) => {
    return (
        <div>
            <h4>{title}</h4>
            {radioGroup.map((rb: TRadioGroupItem) => {
                return (
                    <div key={rb.value + rb.label}>
                        <input 
                            type="radio" 
                            value={rb.value}
                            checked={rb.checked}
                            name={name}
                            onChange={onChange}
                        />
                        <span>
                            {rb.label}
                        </span>
                    </div>
                )
            })}
        </div>
    )
}

export default RadioGroup