import { useCallback, useEffect, useState } from "react"
import PostFunc from "../PostFunc/PostFunc"

const BlogFunc = () => {
    const [showForm, setShowForm] = useState(false)
    const [showForm2, setShowForm2] = useState(false)
    const [count, setCount] = useState(0)
    const [posts, setPosts] = useState<any>([
      {title: 'Test Post', author: 'John Doe', id: '1'},
      {title: 'Hello, world', author: 'Jack Black', id: '2'},
      {title: 'Another example', author: 'Main Editor', id: '3'},
    ])
    useEffect(() => {
        // didMount
        // const getPosts = async () => {
        //     const resposne = await fetch('https://jsonplaceholder.typicode.com/posts/?_limit=3')
        //     const postsResponse = await resposne.json()
        //     setPosts(postsResponse)
        // }
        // getPosts()
        console.log('[BLOG] has mounted')
        const timer = setInterval(() => {}, 1000)
        return () => {
            console.log('[BLOG] unmount')
            clearInterval(timer)
        }
    }, [])

    useEffect(() => {
        // didMount

        console.log('[BLOG] update')
    }, [showForm])

    const toggle = () => {
        setShowForm(!showForm)
    }
    const toggle2 = () => {
        setShowForm2(!showForm2)
    }
    console.log('[BLOG] render')
    const incrementInBlog = useCallback(() => {
        setCount(prevState => {
            return prevState + 1
        })
    }, [])

    return (
        <div>
            <h1>{count}</h1>
            <button onClick={toggle}>TOggle form</button>
            <button onClick={toggle2}>TOggle2 form</button>
            {JSON.stringify(showForm2)}
            {showForm ? <h3>FORM</h3> : null}
            {JSON.stringify(posts)}
            <h1>Blog Func</h1>
            {posts.map((p: any, i: number) => {
                return (<PostFunc 
                    key={i}
                    author={p.author}
                    title={p.title}
                    showForm={showForm}
                    increment={incrementInBlog}
                />)
            })}
        </div>
    )
}
export default BlogFunc