import React, {Component, PureComponent} from 'react';
import './Post.css';

interface Props {
   title: string;
   author: string;
}

class Post extends PureComponent<Props > {
  constructor(props: Props) {
      super(props)
      console.log('[POST] initialized')
  }

  componentDidMount(): void {
      console.log('[POST] has mounted')
  }

    componentDidUpdate(): void {
      console.log('[POST] update')
  }

//   shouldComponentUpdate(
//     nextProps: Readonly<Props>, 
//     nextState: Readonly<{}>
// ): boolean {
//       console.log('[POST] should update')
//       return this.props.author !== nextProps.author || this.props.title !== nextProps.title
//   }

  render() {
    console.log('[POST] render')
    return (
      <article className="Post">
        <h1>{this.props.title}</h1>
        <div className="Info">
          <div className="Author">{this.props.author}</div>
        </div>
      </article>
    );
  }
}

export default Post;