import type { TInstance } from "../../types/TInstance"
import ListItem from "../ListItem/ListItem"

type Props = {
    items: TInstance[]
    setItems: (cb: (data: TInstance[]) => TInstance[]) => void
}

const List = ({items, setItems}: Props) => {
    return (
        <ul>
            {items.map((item: TInstance) => {
                return (
                    <ListItem 
                        key={item.id}
                        item={item}
                        setItems={setItems}
                    />
                )
            })}
        </ul>
    )
}

export default List