import { useState, type ChangeEvent } from "react"
import { axiosInstance } from "../../axios/axiosInstance"
import type { TInstance } from "../../types/TInstance"

type Props = {
    item: TInstance
    setItems: (cb: (data: TInstance[]) => TInstance[]) => void
}
const ListItem = ({item, setItems}: Props) => {
    const [isEditing, setIsEditing] = useState<boolean>(false)
    const [value, setValue] = useState<string>(item.content)

    const inputHandler = (e: ChangeEvent<HTMLTextAreaElement>) => {
        setValue(e.target.value)
    }
    const deleteHandler = async () => {
        try {
            await axiosInstance.delete(`todo/${item.id}.json`)
            setItems((prev: TInstance[]) => {
                const copyState = prev.filter((p: TInstance) => p.id !== item.id)
                return copyState
            })
        } catch (err) {
            console.log(err)
        }
    }

    const saveHandler = async () => {
         try {
            await axiosInstance.patch(`todo/${item.id}.json`, {
                content: value
            })
            setItems((prev: TInstance[]) => {
                const idx = prev.findIndex((p: TInstance) => p.id === item.id)
                prev[idx].content = value
                return prev
            })
            setIsEditing(false)
        } catch (err) {
            console.log(err)
        }
    }
    return (
        <li>
            {isEditing ? <textarea onChange={inputHandler} value={value}/> : <p>{item.content}</p>}
            <button onClick={deleteHandler}>DELETE</button>
            {isEditing 
            ? 
                <div>
                    <button onClick={() => {
                            setIsEditing(false)
                            setValue(item.content)
                        }}>CANCEL</button>
                    <button onClick={saveHandler}>SAVE</button>
                </div> 
            : 
                <button onClick={() => setIsEditing(true)}>EDIT</button>}
        </li>
    )
}

export default ListItem