import { useEffect, useState } from 'react'
import Form from '../../components/Form/Form'
import List from '../../components/List/List'
import styles from './MoviePage.module.css'
import type { TInstance } from '../../types/TInstance'
import { axiosInstance } from '../../axios/axiosInstance'
import type { TFirebaseData } from '../../types/TFirebaseData'
import { firebaseParser } from '../../components/utils/firebaseParser'

const MoviePage = () => {
    const [items, setItems] = useState<TInstance[]>([])
    
    useEffect(() => {
        const fetchData = async() => {
            try {
                const response = await axiosInstance.get('movie.json')
                const data: TFirebaseData = response.data
                setItems(firebaseParser(data))
            } catch(err) {
                console.log(err)
            }
        }
        fetchData()
    }, [])

    return (
        <section className={styles.Movie}>
            <h1>Movie Page</h1>
            <Form 
                path='movie.json'
                placeholder='Type you Movie here!'
                setItems={setItems}
                multiline={true}
            />
            <hr />
            <List items={items} setItems={setItems} />
        </section>
    )
}

export default MoviePage