import { useEffect, useState } from 'react'
import Form from '../../components/Form/Form'
import List from '../../components/List/List'
import styles from './TodoPage.module.css'
import type { TInstance } from '../../types/TInstance'
import { axiosInstance } from '../../axios/axiosInstance'
import type { TFirebaseData } from '../../types/TFirebaseData'
import { firebaseParser } from '../../components/utils/firebaseParser'

const TodoPage = () => {
    const [items, setItems] = useState<TInstance[]>([])
    
    useEffect(() => {
        const fetchData = async() => {
            try {
                const response = await axiosInstance.get('todo.json')
                const data: TFirebaseData = response.data
                setItems(firebaseParser(data))
            } catch(err) {
                console.log(err)
            }
        }
        fetchData()
    }, [])

    return (
        <section className={styles.Todo}>
            <h1>Todo Page</h1>
            <Form 
                path='todo.json'
                placeholder='Type you Todo here!'
                setItems={setItems}
            />
            <hr />
            <List items={items} setItems={setItems} />
        </section>
    )
}

export default TodoPage