import { useState, type ChangeEvent, type FormEvent } from "react"
import Input from "../UI/Input/Input"
import styles from './Form.module.css'
import { axiosInstance } from "../../axios/axiosInstance"
import type { TCreateInstanceDto } from "../../types/TCreateInstanceDto"
import type { TInstance } from "../../types/TInstance"

type Props = {
    path: string
    placeholder?: string
    setItems: (cb: (data: TInstance[]) => TInstance[]) => void
    multiline?: boolean
}

const Form = ({path, placeholder, setItems, multiline = false}: Props) => {
    const [inputValues, setInputValues] = useState<TCreateInstanceDto>({
        content: ''
    })

    const inputHandler = (e: ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
        setInputValues(prev => ({...prev, [e.target.name]: e.target.value}))
    }

    const submit = async (e: FormEvent<HTMLFormElement>) => {
        e.preventDefault()
        try {
            const response = await axiosInstance.post(path, {
                content: inputValues.content
            })
            if (response.data.name) {
                setItems(prev => ([...prev, {id: response.data.name, content: inputValues.content}]))
            }
            setInputValues({content: ''})
        } catch(err) {
            console.log(err)
        }
    }
    return (
        <div className={styles.Form}>
            <form onSubmit={submit}>
                <Input multiline={multiline} placeholder={placeholder} onChange={inputHandler} value={inputValues.content} name={'content'} />
                <button>SUBMIT</button>
            </form>
        </div>
    )
}

export default Form