import styles from './Input.module.css'
import type { ChangeEventHandler } from "react"

type Props = {
    multiline?: boolean
    onChange: ChangeEventHandler
    value: string
    placeholder?: string
    name: string
}

const Input = ({multiline = false, onChange, value, placeholder, name}: Props) => {
    return (
        <>
        {multiline 
            ? 
                <textarea placeholder={placeholder} name={name} className={styles.Input} rows={5} value={value} onChange={onChange} /> 
            : 
                <input placeholder={placeholder} name={name} className={styles.Input} type="text" value={value} onChange={onChange} />
        }
        </>
        
    )
}

export default Input