import { StrictMode } from 'react'
import { createRoot } from 'react-dom/client'
import './index.css'
import { createBrowserRouter, RouterProvider } from 'react-router'
import Layout from './components/layouts/Layout/Layout'
import TodoPage from './pages/TodoPage/TodoPage'
import MoviePage from './pages/MoviePage/MoviePage'

const router = createBrowserRouter([
  {
    path: '/',
    element: <Layout />,
    children: [
      {
        index: true,
        element: <h1>Welcome to Homework 62</h1>
      },
      {
        path: 'todo',
        element: <TodoPage />
      },
      {
        path: 'movie',
        element: <MoviePage />
      }
    ]
  }
])


createRoot(document.getElementById('root')!).render(
  <StrictMode>
    <RouterProvider router={router} />
  </StrictMode>,
)
