import { createContext, useEffect, useState, type ChangeEvent } from "react"
import { useSearchParams } from "react-router"
import Temp from "./components/Temp"

type Post = {
  id: string
  title: string
  body: string
}
export const PostsContext = createContext<Post[]>([])
export const InputContext = createContext('')

function App() {

  const [posts, setPosts] = useState<Post[]>([])
  const [searchParams, setSearchParams] = useSearchParams()
  const [value, setValue] = useState(searchParams.get('equalTo') || '')
  
  useEffect(() => {

    const fetchData = async() => {
      const myQuery = new URLSearchParams()
      myQuery.append('orderBy', '"title"')
      if (searchParams.get('equalTo')) {
        myQuery.append('equalTo', `"${searchParams.get('equalTo') || ''}"`)
      }
      const response = await fetch(
        `https://burger-project-ajs-22-default-rtdb.firebaseio.com/posts.json${'?' + myQuery.toString()}`)
      const data = await response.json()
      const result: Post[] = []
      Object.keys(data).forEach((key) => {
        if (data[key].title) {
          result.push({
            id: key,
            title: data[key].title || '',
            body: data[key].body || ''
          })
        }
      })
      setPosts(result)
    }
    fetchData()
  }, [searchParams])

  const inputHandler = (e: ChangeEvent<HTMLInputElement>) => {
    setValue(e.target.value)
  }
  const clickHandler = () => {
    searchParams.set('equalTo', value)
    setSearchParams(searchParams)
  }
  return (
    <>
    <>
     <PostsContext value={posts}>
      <InputContext value={value}>
      <div>
        <input type="text" placeholder="Search by title" value={value} onChange={inputHandler}  />
        <button onClick={clickHandler}>SEARCH</button>
      </div>
     {JSON.stringify(posts)}
        <Temp />
        {/* ANY COMPONENT */}
        </InputContext>
     </PostsContext>
     </>
    </>
  )
}

export default App
