import { useEffect, useState } from "react"
import { NavLink, useParams } from "react-router"
import type { TQuote } from "../../types/TQuote"
import { mainInstance } from "../../axios/mainInstance"
import type { TFirebaseQuote } from "../../types/TFirebaseQuote"
import type { TCategory } from "../../types/TCategory"
import ListItem from "../ListItem/ListItem"

const List = () => {
    const {category} = useParams()
    const [quotes, setQuotes] = useState<TQuote[]>([])
    const [categories, setCategories] = useState<TCategory[]>([])

     useEffect(() => {
        const fetchCategories = async() => {
            try {
                const response = await mainInstance.get('categories.json')
                if (response?.data) {
                    setCategories(Array.from(response.data))
                }
            } catch(err) {
                console.log(err)
            }
        }
        fetchCategories()
    }, [])

    useEffect(() => {
        const fetchQuotes = async() => {
            try {
                const response = await mainInstance
                    .get('quotes.json' + (category ? `?orderBy="category"&equalTo="${category}"` : ''))
                if (response?.data) {
                    const firebaseQuotes: TFirebaseQuote = response.data
                    setQuotes(Object.keys(firebaseQuotes).map(key => {
                        const quote = firebaseQuotes[key]
                        return {
                            id: key,
                            author: quote.author,
                            category: quote.category,
                            text: quote.text
                        }
                    }))
                }
            } catch(err) {
                console.log(err)
            }
        }
        fetchQuotes()
    }, [category])

    return (
        <>
            <aside>
                <NavLink to={{
                    pathname: "/quotes",
                }}>All</NavLink>
                {categories.map(cat => {
                    return (
                        <NavLink to={{
                            pathname: `/quotes/${cat.value}`,
                        }}>{cat.label}</NavLink>
                    )
                })}
            </aside>
            <h1>QUOTES</h1>
            <ul>
                {quotes.map(quote => {
                    return (
                        <ListItem 
                            key={quote.id}
                            quote={quote}
                            setQuotes={setQuotes}
                        />
                    )
                })}
            </ul>
        </>
    )
}

export default List