import { useNavigate } from "react-router"
import type { TQuote } from "../../types/TQuote"
import { mainInstance } from "../../axios/mainInstance"

type Props = {
    quote: TQuote
    setQuotes: (cb: (value: TQuote[]) => TQuote[]) => void
}



const ListItem = ({quote, setQuotes}: Props) => {
    const navigate = useNavigate()
    const editHandler = () => {
        navigate(`/edit/${quote.id}`)
    }
    const deleteHandler = async () => {
        try {
            await mainInstance.delete(`quotes/${quote.id}.json`)
            setQuotes(prev => (prev.filter(q => q.id !== quote.id)))
        } catch(err) {
            console.log(err)
        }
    }

    return (
        <li>
            <div>
                <hr />
                <p>Author: {quote.author}</p>
                <i>{quote.text}</i>
                <p>CATEGORY: {quote.category}</p>
                <button onClick={editHandler}>Edit</button>
                <button onClick={deleteHandler}>Delete</button>
                <hr />
            </div>
        </li>
        
    )
}

export default ListItem