import { StrictMode } from 'react'
import { createRoot } from 'react-dom/client'
import './index.css'
import { createBrowserRouter, RouterProvider } from 'react-router'
import RootLayout from './components/layouts/RootLayout/RootLayout'
import Form from './components/Form/Form'
import List from './components/List/List'

const router = createBrowserRouter([
  {
    path: '/',
    element: <RootLayout />,
    children: [
      {
        path: 'add-quote',
        element: <Form type='add' />
      },
      {
        path: 'edit/:quoteId',
        element: <Form type='edit' />
      },
      {
        path: 'quotes',
        element: <List />
      },
      {
        path: 'quotes/:category',
        element: <List />
      }
    ]
  },
  {
    path: '*',
    element: <h1>Page not found</h1>
  }
])

createRoot(document.getElementById('root')!).render(
  <StrictMode>
    <RouterProvider router={router} />
  </StrictMode>,
)
