const redux = require('@reduxjs/toolkit')
const initialState = {
    count: 0,
    user: {}
}
const rootReducer = (state = initialState, action) => {
    switch(action.type) {
        case 'INC_COUNT':
            return {...state, count: state.count + 1}
        case 'ADD_COUNT':
            return {...state, count: state.count + action.value}
        default:
            return state
    }
}

const store = redux.configureStore({reducer: rootReducer})
store.subscribe(() => {
    console.log('[SUBSCRIPTION]: ', store.getState())
})

console.log(store.getState())
store.dispatch({type: 'INC_COUNT'})
store.dispatch({type: 'ADD_COUNT', value: 10})
console.log(store.getState())
