import { axiosInstance } from "@/axios/axios";
import { AxiosInstance } from "axios";

class CountApi {
    instance: AxiosInstance = axiosInstance

    getCount = async () => {
        try {
            const response = await this.instance.get('count.json')
            return response.data
        } catch (err) {
            console.log(err)
        }
    }
    putCount = async (num: number) => {
        try {
            await this.instance.put('count.json', num)
        } catch (err) {
            console.log(err)
        }
    }
}

export const countApi = new CountApi()