'use client'
import { useAppSelector } from '@/hooks/useAppSelector';
import styles from './Count.module.css'
import { useAppDispatch } from '@/hooks/useAppDispatch';
import { decreaseCount, getCount, increaseCount, minusCount, putCount, plusCount } from '@/store/count/count.slice';
import Temp from '../Temp/Temp';
import { useEffect, useState } from 'react';
import Spinner from '../UI/Spinner/Spinner';

const Count = () => {
    const {count, loading} = useAppSelector(state => state.count)
    const dispatch = useAppDispatch()
    const [isMounted, setIsMounted] = useState<boolean>(false)
    
    useEffect(() => {
        dispatch(getCount())
    }, [])

    useEffect(() => {
        if (isMounted) {
            dispatch(putCount(count))
        } else {
            setIsMounted(true)
        }
    }, [count])

    console.log('RERENDER Count')

     return (
        <div className={styles.Count}>

            {loading 
            ? 
                <Spinner />
            : <h1>{count}</h1>}

            <Temp />
            <button onClick={() => dispatch(increaseCount())}>Increase</button>
            <button onClick={() => dispatch(decreaseCount())}>Decrease</button>
            <button onClick={() => dispatch(plusCount(5))}>Increase by 5</button>
            <button onClick={() => dispatch(minusCount(5))}>Decrease by 5</button>
        </div>  
  );
}
export default Count