import React, { useEffect, useState } from 'react';
import { axiosOrder } from '../../axios/axiosOrder';
import type { TFirebaseData } from "../../types/TFirebaseData";

import { TOrder } from '../../types/TOrder';
import OrderItem from '../OrderItem/OrderItem';
import Spinner from '../UI/Spinner/Spinner';

const Orders = () => {
    const [orders, setOrders] = useState<TOrder[]>([]);
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        const fetchData = async () => {
            const response = await axiosOrder.get('orders.json');
            const data: TFirebaseData<TOrder> = response.data
            console.log(response.data)
            if (!data) return
            const fetchedOrders = Object.keys(data).map(id => {
                return { ...data[id], id };
            });
            setOrders(fetchedOrders);
        };
        setLoading(true);
        fetchData().finally(() => setLoading(false));
    }, []);

    let content: React.ReactElement | React.ReactElement[] = orders.map(order => {
        return (
            <OrderItem key={order.id}
                ingredients={order?.ingredients || {}}
                price={order.price || 0}
            />
        )
    });

    if (loading) {
        content = <Spinner />;
    }
    return content;
}

export default Orders;