import { useRef } from "react";
import { TIngredients } from "../../types/TIngredients";
import { CheckoutSummary } from "../CheckoutSummary/CheckoutSummary";
import { useNavigate, useSearchParams } from "react-router-dom";




export function Checkout() {
    const [searchParams] = useSearchParams()
    const ingredients = useRef(Object.fromEntries(searchParams) as unknown as TIngredients)

    const navigate = useNavigate();

    const checkoutCancelledHandler = () => {
        navigate('/');
    };

    const checkoutContinuedHandler = () => {
        navigate('contact-data');
    };

    return <CheckoutSummary 
                ingredients={ingredients.current} 
                checkoutContinued={checkoutContinuedHandler}
                checkoutCancelled={checkoutCancelledHandler}
            />;
}