import { CheckoutSummary } from "../CheckoutSummary/CheckoutSummary";
import { useNavigate, useSearchParams } from "react-router-dom";





export function Checkout() {
    const [searchParams] = useSearchParams()
    const navigate = useNavigate();

    const checkoutCancelledHandler = () => {
        navigate('/');
    };


    const checkoutContinuedHandler = () => {
        navigate({
            pathname: 'contact-data',
            search: searchParams.toString()
        });
    };

    return <CheckoutSummary 
                checkoutContinued={checkoutContinuedHandler}
                checkoutCancelled={checkoutCancelledHandler}
            />;
}