'use client'
import { useAppSelector } from "../../hooks/useAppSelector";
import Burger from "../Burger/Burger";
import Button from "../UI/Button/Button";
import styles from "./CheckoutSummary.module.css";
import { MouseEventHandler } from "react";
import { Outlet } from "react-router-dom";

interface Props {
    checkoutContinued: MouseEventHandler<HTMLButtonElement>
    checkoutCancelled: MouseEventHandler<HTMLButtonElement>
}

export function CheckoutSummary({ checkoutContinued, checkoutCancelled }: Props) {
    const {totalPrice} = useAppSelector(state => state.burger)
    return (
        <div className={styles.CheckoutSummary}>
            <h1>We hope it tastes well!</h1>
            <h2>Price: {totalPrice}</h2>
            <div className={styles.CheckoutSummaryBurger}>
                <Burger />
            </div>
            <Button btnType="Danger" onClick={checkoutCancelled}>
                CANCEL
            </Button>
            <Button btnType="Success" onClick={checkoutContinued}>
                CONTINUE
            </Button>
            <Outlet />
        </div>
    );

}