'use client'

import { useEffect } from 'react';
import { useAppSelector } from '../../hooks/useAppSelector';
import OrderItem from '../OrderItem/OrderItem';
import { useAppDispatch } from '../../hooks/useAppDispatch';
import { getOrders } from '../../stores/newStore/ordersSlice';

const Orders = () => {
    const {orders} = useAppSelector(state => state.orders)
    const dispatch = useAppDispatch()

    useEffect(() => {
        dispatch(getOrders())
    }, [dispatch])

    return (
        <>
        {orders.map(order => {
            return (
                <OrderItem key={order.id}
                    ingredients={order?.ingredients || {}}
                    price={order.price || 0}
                />
            )
        })}
    </>
    );
}

export default Orders;