import { configureStore } from "@reduxjs/toolkit";
import burgerReducer from './burgerSlice'
import ordersReducer from './ordersSlice'

const store = configureStore({
    reducer: {
        burger: burgerReducer,
        orders: ordersReducer
    }
})

export type RootState = ReturnType<typeof store.getState>
export type AppStore = typeof store
export type AppDispatch = typeof store.dispatch

export default store