'use client'
import { ChangeEvent, FormEvent, useState } from 'react';
import Button from '../UI/Button/Button';
import styles from './ContactData.module.css';
import { TCustomerData } from '../../types/TCustomerData';
import { useNavigate } from 'react-router';
import Spinner from '../UI/Spinner/Spinner';
import { useAppSelector } from '../../hooks/useAppSelector';
import { useAppDispatch } from '../../hooks/useAppDispatch';
import { createOrder } from '../../stores/newStore/ordersSlice';
import { shallowEqual } from 'react-redux';

export function ContactData() {
  const {ingredients, totalPrice} = useAppSelector(state => state.burger)
  const {isLoading} = useAppSelector(state => state.orders, shallowEqual)
  const dispatch = useAppDispatch()
  const navigate = useNavigate()
  const [isSubmited, setIsSubmited] = useState<boolean>(false)
  const [customerData, setCustomerData] = useState<TCustomerData>({
    name: '',
    email: '',
    street: '',
    postal: ''
  })


  const inputHandler = (e: ChangeEvent<HTMLInputElement>) => {
    setCustomerData(prevState => ({ ...prevState, [e.target.name]: e.target.value }))
  }

  const submit = async (e: FormEvent<HTMLFormElement>) => {
    e.preventDefault()
    if (isSubmited) return
    try {
      const order = {
        customer: { ...customerData },
        ingredients,
        price: totalPrice
      }
      dispatch(createOrder(order))
      setIsSubmited(true)
    } catch (err) {
      console.log(err)
      setIsSubmited(false)
    }
  }
  const goBack = () => {
    navigate('/')
  }
  return (
    <div className={styles.ContactData}>
      {isLoading ?
          <Spinner />
        :
        isSubmited ?
          <>
            <h1>
              Your order is successful
            </h1>
            <Button btnType='Success' onClick={goBack}>Go back</Button>
          </>

          :
          <>
            <h4>Enter your Contact Data</h4>
            <form onSubmit={submit}>
              <input onChange={inputHandler} value={customerData.name} className={styles.Input} type="text" name="name" placeholder="Your Name" />
              <input onChange={inputHandler} value={customerData.email} className={styles.Input} type="email" name="email" placeholder="Your Mail" />
              <input onChange={inputHandler} value={customerData.street} className={styles.Input} type="text" name="street" placeholder="Street" />
              <input onChange={inputHandler} value={customerData.postal} className={styles.Input} type="text" name="postal" placeholder="Postal Code" />
              <Button btnType="Success">
                ORDER
              </Button>
            </form>
          </>
      }

    </div>
  );
}