// Viselitsa

// array with words (infinit)
// get random word
// delete this random word from array
// convert chosen word into lines ------
// ask user a letter (add validation (repeated letters))
// 7 tries in total
// if letter is in the word show all these letters
// track the score
// if there are no words show message there are no words
// If CANCEL stop game show results


const Game = {
    words: ["apple"],
    chosenWord: null,
    cipherWord: null,
    steps: 7,
    wins: 0,
    losts: 0,
    alphabet: ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'],
    // words: ["apple", "understand", "hello", "cat"],
    getRandomNumber: function (min = 0, max = this.words.length - 1) {
        return Math.floor(Math.random() * (max - min + 1) + min)
    },
    getLetterFromUser: function() {
        let letter = ''
        while(letter.length === 0 || letter.length > 1 || parseInt(letter) >= 0) {
            letter = prompt(
                `
                ${this.printEchafot()}
                Available letters: ${this.alphabet.join(', ')}
                ##############################################
                STEPS: ${this.steps}

                
                
                Your word:
                ${this.cipherWord}

                Type ONE letter please:
                `
            )
    
            if (letter === null) {
                break
            } else {
                letter = letter.toLowerCase().trim()
            }
        } 
        return letter
    },
    choseWord: function() {
        const idx = this.getRandomNumber()
        this.chosenWord = this.words[idx]
        this.words.splice(idx, 1)
    },
    hideWord: function() {
        let result = ''
        for (let i = 0; i < this.chosenWord.length; i++) {
            result += '*'
        }
        this.cipherWord = result
    },
    run: function() {
        if (!this.words.length) {
            alert('No more words')
            return
        }
        this.steps = 7
        this.choseWord()
        this.hideWord()
        let letter
        while (this.steps > 0) {
            letter = this.getLetterFromUser()
            if (letter === null) {
                break
            }
            this.checkLetter(letter)
            if (this.chosenWord === this.cipherWord) {
                break
            }
        }
        if (letter === null) {
            this.printResult()
        } else {
            this.printAndASkFinal()
        }
    },
    printAndASkFinal: function() {
        if (this.steps > 0) {
            const answer = prompt(`
                You won!
                Steps left: ${this.steps}
                Your word was: 
                ${this.chosenWord}

                Wanna play more?
                `)
                this.wins++
                if (answer) {
                    this.run()
                } else {
                    this.printResult()
                }
        } else {
            const answer = prompt(`
                You Lost(((((
                No steps left

                Wanna play more?
                `)
                this.losts++
                if (answer) {
                    this.words.push(this.chosenWord)
                    this.run()
                } else {
                    this.printResult()
                }
        }
    },
    checkLetter: function(letter) {
        const arr = this.cipherWord.split('')
        let isWrong = true
        for (let i = 0; i < this.chosenWord.length; i++) {
            if (this.chosenWord[i] === letter) {
                arr[i] = letter
                isWrong = false
            }
        }
        const index = this.alphabet.indexOf(letter)
        if (index >= 0) {
            this.alphabet.splice(index, 1)
        } else {
            isWrong = false
        }

        if (isWrong) {
            this.steps--
        }
        this.cipherWord = arr.join('')
    },
    printResult: function() {
        alert(`
            Wins: ${this.wins}
            Losts: ${this.losts}
            `)
    },
    printEchafot: function() {
                    const stages = [
                        `
                +---+
                |      |
                        |
                        |
                        |
                        |
            ======= 
            `,

            `
                +---+
                |      |
                O     |
                        |
                        |
                        |
            =======
            `,

            `
                +---+
                |      |
                O     |
                |      |
                        |
                        |
            =======
            `,

            `
                +---+
                |      |
                O     |
            / |      |
                        |
                        |
            =======
            `,

            `
                +---+
                |      |
                O     |
            / | \\   |
                        |
                        |
            =======
            `,

            `
                +---+
                |      |
                O     |
            / | \\   |
                /      |
                        |
            =======
            `,

            `
                +---+
                |      |
                O     |
            / | \\   |
                / \\    |
                        |
            =======
            `
            ]
        return stages[this.steps - 1]
    }
}
