const days = [ 'Пн', 'Вт', 'Ср', 'Чт', 'Пт', 'Сб', 'Вс',];
const months = [ 'Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь', ]


const container = document.getElementById('container')
const input = document.getElementsByClassName('date-input')


const datePicker = document.createElement('div')
datePicker.className = 'date-picker'
container.append(datePicker)


input[0].addEventListener('focus', () => {
    datePicker.style.display = 'block'
})

let currentDate = new Date()
const year =  currentDate.getFullYear()


const getDaysInMonth = (year, month) => new Date(year, month+1, 0).getDate()

const getFirstDayOfMonth = (year, month) => new Date(year, month, 1).getDay()


console.log(getDaysInMonth(year, 5));
console.log(getFirstDayOfMonth(year, 5));

const monthName = () => months[currentDate.getMonth()]


const setWeek = () => {
    const week = document.createElement('div')
    for (const day of days) {
        week.append(`<div class='dayOfWeek'>${day}</div>`)
    }
    return week.innerText
}

const setDays = () => {
    const days = document.createElement('div')
    const currentMonth = currentDate.getMonth()
    const totalDays = getDaysInMonth(year, currentMonth)
    const firstDay = getFirstDayOfMonth(year, currentMonth)
    for(let i = 1; i < firstDay; i++) {
        const dayElement = document.createElement('div')
        days.appendChild(dayElement)
    }
    for (let i = 1; i <= totalDays; i++) {
        const dayElement = document.createElement('button')
        dayElement.className = 'day'
        dayElement.innerText = i
        days.appendChild(dayElement)
    }
    return days.innerHTML
}

function drawCalendar() {
    const month = monthName()
    const week = setWeek()
    const days = setDays()

    const printCurrentDate = `<div class='calendarHead'>${month} ${year}</div>`
    const printWeek = `<div class='week'>${week}</div>`
    const printDays = `<div class='days'>${days}</div>`

    const calendar = `
        ${printCurrentDate}
        ${printWeek}
        ${printDays}
    `
    datePicker.innerHTML = calendar
}

drawCalendar()




const printDate = () => {
    const datePick = document.getElementsByClassName('day')

    const month = currentDate.getMonth()+1

    for(const day of datePick) {
        day.addEventListener('click', () => {

            input[0].value = `${year}-${month < 10 ? '0' + month : month}-${day.innerText.length < 2 ? '0' + day.innerText : day.innerText }`
            datePicker.style.display = 'none'
            
        })
    }
}


printDate()
