'use client'

import { useUserStore } from '@/features/userStore'
import { axiosApiClient } from '@/helpers/axiosClient'
import Link from 'next/link'
import { useRouter } from 'next/navigation'
import { FormEvent, useState } from 'react'
import styles from './LoginPage.module.css'

export default function Page() {
	const router = useRouter()

	const { user, setUser } = useUserStore()

	const [userName, setUserName] = useState(user?.userName ?? '')
	const [password, setPassword] = useState('')

	const onSubmit = async (e: FormEvent) => {
		e.preventDefault()

		const newUser = {
			userName,
			password,
		}

		const { data } = await axiosApiClient.post('/auth/login', newUser)
		setUser(data)

		router.push('/')
	}

	return (
		<main className={styles.wrapper}>
			<form onSubmit={onSubmit} className={styles.card} noValidate>
				<h1 className={styles.title}>Логин</h1>

				<div className={styles.field}>
					<label className={styles.label} htmlFor='userName'>
						Логин
					</label>
					<input
						id='name'
						className={styles.input}
						value={userName}
						onChange={e => setUserName(e.target.value)}
						placeholder='name'
					/>
					{!userName && <p className={styles.error}>Введите логин</p>}
				</div>

				<div className={styles.field}>
					<label className={styles.label} htmlFor='password'>
						Пароль
					</label>
					<input
						id='password'
						type='password'
						className={styles.input}
						value={password}
						onChange={e => setPassword(e.target.value)}
						placeholder='••••••'
					/>
					{password && password.length < 6 && (
						<p className={styles.error}>Минимум 6 символов</p>
					)}
				</div>

				<button className={styles.button}>Войти</button>
				<p className={styles.hint}>
					Аккаунта нет?
					<Link href='/auth/registration' className={styles.link}>
						Регистрация
					</Link>
				</p>
			</form>
		</main>
	)
}
