"use client";

import { FormEvent, useState } from "react";
import styles from "./RegisterPage.module.css";
import Link from "next/link";
import { useUserStore } from "@/features/userStore";
import { axiosApiClient } from "@/helpers/axiosClient";
import { useRouter } from "next/navigation";

export default function Page() {
    const router = useRouter();

    const { user, setUser } = useUserStore();

    const [userName, setUserName] = useState(user?.userName ?? "");
    const [displayName, setDisplayName] = useState(user?.displayName ?? "");
    const [password, setPassword] = useState("");

    const onSubmit = async (e: FormEvent) => {
        e.preventDefault();

        const newUser = {
            userName,
            displayName,
            password,
        };
        const { data } = await axiosApiClient.post("/auth/register", newUser);
        setUser(data);

        router.push("/");
    };

    return (
        <main className={styles.wrapper}>
            <form onSubmit={onSubmit} className={styles.card} noValidate>
                <h1 className={styles.title}>Регистрация</h1>

                <div className={styles.field}>
                    <label className={styles.label} htmlFor="userName">
                        Логин
                    </label>
                    <input
                        id="name"
                        className={styles.input}
                        value={userName}
                        onChange={(e) => setUserName(e.target.value)}
                        placeholder="name"
                    />
                    {!userName && <p className={styles.error}>Введите логин</p>}
                </div>

                <div className={styles.field}>
                    <label className={styles.label} htmlFor="displayName">
                        Отображаемое имя
                    </label>
                    <input
                        id="displayName"
                        className={styles.input}
                        value={displayName}
                        onChange={(e) => setDisplayName(e.target.value)}
                        placeholder="displayName"
                    />
                </div>

                <div className={styles.field}>
                    <label className={styles.label} htmlFor="password">
                        Пароль
                    </label>
                    <input
                        id="password"
                        type="password"
                        className={styles.input}
                        value={password}
                        onChange={(e) => setPassword(e.target.value)}
                        placeholder="••••••"
                    />
                    {password && password.length < 6 && <p className={styles.error}>Минимум 6 символов</p>}
                </div>

                <button className={styles.button}>Зарегистрироваться</button>
                <p className={styles.hint}>
                    Уже есть аккаунт?
                    <Link href="/login" className={styles.link}>
                        Войти
                    </Link>
                </p>
            </form>
        </main>
    );
}
