'use client'

import { createProduct } from '@/features/productsSlice'
import { useAppDispatch } from '@/store/hooks'
import { Box, Button, Grid2, TextField } from '@mui/material'
import { useRouter } from 'next/navigation'
import { ChangeEvent, FormEvent, useState } from 'react'
import FileInput from '../UI/Input/FileInput'

interface State {
	id: string
	title: string
	price: string
	description: string
	image?: File
}

const ProductForm = () => {
	const router = useRouter()
	const dispatch = useAppDispatch()

	const [state, setState] = useState<State>({
		id: '',
		title: '',
		price: '',
		description: '',
	})

	const submitFormHandler = (e: FormEvent<HTMLFormElement>) => {
		e.preventDefault()

		const formData: FormData = new FormData()

		Object.entries(state).forEach(([key, value]) => {
			if (typeof value === 'object') {
				formData.append(key, value)
			} else {
				formData.append(key, `${value}`)
			}
		})

		dispatch(createProduct(formData))
		router.push('/')
	}

	const inputChangeHandler = (e: ChangeEvent<HTMLInputElement>) => {
		const { name, value } = e.target

		setState(prevState => {
			return { ...prevState, [name]: value }
		})
	}

	const onFileChange = (e: ChangeEvent<HTMLInputElement>) => {
		if (e?.target?.files?.[0]) {
			const name = e.target.name

			const file: File = e.target.files[0]

			setState(prevProduct => {
				return { ...prevProduct, [name]: file }
			})
		}
	}

	return (
		<Box
			component={'form'}
			autoComplete='off'
			onSubmit={submitFormHandler}
			paddingY={2}
		>
			<Grid2 container direction='column' spacing={2}>
				<Grid2>
					<TextField
						fullWidth
						variant='outlined'
						id='title'
						label='Title'
						value={state.title}
						onChange={inputChangeHandler}
						name='title'
					/>
				</Grid2>

				<Grid2>
					<TextField
						fullWidth
						variant='outlined'
						id='price'
						label='Price'
						value={state.price}
						onChange={inputChangeHandler}
						name='price'
					/>
				</Grid2>

				<Grid2>
					<TextField
						fullWidth
						multiline
						rows={3}
						variant='outlined'
						id='description'
						label='Description'
						value={state.description}
						onChange={inputChangeHandler}
						name='description'
					/>
				</Grid2>

				<Grid2>
					<FileInput
						name='image'
						label='Image'
						onChange={onFileChange}
						accept={'image/*'}
					/>
				</Grid2>

				<Grid2>
					<Button type='submit' color='primary' variant='contained'>
						Create
					</Button>
				</Grid2>
			</Grid2>
		</Box>
	)
}

export default ProductForm
