'use client'

import { Container, CssBaseline } from '@mui/material'
import { ReactNode } from 'react'
import AppToolbar from '../UI/AppToolbar/AppToolbar'

interface IProps {
	children: ReactNode
}

const MainLayout = ({ children }: IProps) => {
	return (
		<>
			<CssBaseline />

			<header>
				<AppToolbar />
			</header>

			<main>
				<Container maxWidth={'xl'}>{children}</Container>
			</main>
		</>
	)
}

export default MainLayout
