'use client'

import { IProduct } from '@/interface/product'
import { ArrowForward } from '@mui/icons-material'
import {
	Card,
	CardActions,
	CardContent,
	CardHeader,
	CardMedia,
	Grid2,
	IconButton,
	Typography,
} from '@mui/material'
import Link from 'next/link'

interface Props {
	product: IProduct
}

export function ProductItem({ product }: Props) {
	const { title, price, id, description, image } = product

	let cardImage = 'http://localhost:3000/No_Image_Available.jpg'

	if (image) {
		cardImage = `${process.env.SERVER_URL}/uploads/${image}`
	}

	return (
		<Grid2>
			<Card sx={{ minWidth: 275 }}>
				<CardHeader title={title} />

				<CardMedia
					image={cardImage}
					title={title}
					sx={{ height: 200 }}
				></CardMedia>

				<CardContent>
					<Typography variant='body2'>{description}</Typography>

					<strong style={{ marginLeft: '10px' }}>Price: {price} KZT</strong>
				</CardContent>

				<CardActions>
					<IconButton component={Link} href={`/${id}`}>
						<ArrowForward />
					</IconButton>
				</CardActions>
			</Card>
		</Grid2>
	)
}
