"use client";

import { fetchProducts } from "@/features/productsSlice";
import { useAppDispatch, useAppSelector } from "@/store/hooks";
import { Button, Grid2, styled, Typography } from "@mui/material";
import Link from "next/link";
import { useEffect } from "react";
import { shallowEqual } from "react-redux";
import { ProductItem } from "./ProductItem";

const StyledLink = styled(Link)(() => ({
    color: "inherit",
    textDecoration: "none",
    ["&:hover"]: { color: "inherit" },
}));

const Products = () => {
    const dispatch = useAppDispatch();
    const { products } = useAppSelector((state) => state.products, shallowEqual);
    console.log(products);
    useEffect(() => {
        dispatch(fetchProducts());
    }, [dispatch]);

    return (
        <Grid2 container direction={"column"} spacing={2}>
            <Grid2 container direction={"row"} justifyContent={"space-between"} alignItems={"center"}>
                <Grid2>
                    <Typography variant={"h4"}>Products</Typography>
                </Grid2>

                <Grid2>
                    <Button color="primary" component={StyledLink} href={"/newProduct"}>
                        Add product
                    </Button>
                </Grid2>
            </Grid2>

            <Grid2 container direction={"row"} spacing={1}>
                {products?.map((item) => (
                    <ProductItem key={item.id} product={item} />
                ))}
            </Grid2>
        </Grid2>
    );
};

export default Products;
