import { axiosApiClient } from '@/helpers/axiosClient'
import { IProduct } from '@/interface/product'
import { createAsyncThunk, createSlice } from '@reduxjs/toolkit'

interface State {
	products: IProduct[]
	error: Error | null
	loading: boolean
}

const initialState: State = {
	products: [],
	error: null,
	loading: false,
}

export const fetchProducts = createAsyncThunk('fetch/products', async () => {
	return await axiosApiClient.get<IProduct[]>('/products').then(res => res.data)
})

export const createProduct = createAsyncThunk(
	'create/products',
	async (payload: FormData) => {
		return await axiosApiClient
			.post<IProduct>('/products', payload)
			.then(res => res.data)
	}
)

const productsSlice = createSlice({
	name: 'products',
	initialState,
	reducers: {},
	extraReducers: builder => {
		builder

			.addCase(fetchProducts.fulfilled, (state, action) => {
				state.products = action.payload
				state.loading = false
			})

			.addCase(fetchProducts.rejected, (state, action) => {
				state.error = action.error as Error
				state.loading = false
			})

			.addCase(fetchProducts.pending, state => {
				state.loading = true
			})

			.addCase(createProduct.fulfilled, state => {
				state.loading = false
			})

			.addCase(createProduct.rejected, (state, action) => {
				state.error = action.error as Error
				state.loading = false
			})

			.addCase(createProduct.pending, state => {
				state.loading = true
			})
	},
})

export const productsReducer = productsSlice.reducer
