import axios, { AxiosError } from 'axios'
import { toast } from 'react-toastify'

export const axiosApiClient = axios.create({
	baseURL: 'http://localhost:8000',
})

axiosApiClient.interceptors.response.use(
	res => res,
	(err: AxiosError) => {
		console.log(err)

		toast.error(err.response?.data?.message || 'Что то сломалось, но мы чиним')
	}
)
