'use client'

import { useUserStore } from '@/features/userStore'
import { useRouter } from 'next/navigation'
import { ReactNode, useEffect } from 'react'

type Props = {
	children: ReactNode
}

export const AuthGuard = ({ children }: Props) => {
	const router = useRouter()

	const { user } = useUserStore(state => state)

	useEffect(() => {
		if (!user) {
			router.push('/auth/login')
		}
	}, [user, router])

	return <>{children}</>
}
