'use client'

import store from '@/store'
import { ReactNode } from 'react'
import { Provider } from 'react-redux'
import { AuthGuard } from './AuthGuard'
import ToastifyProvider from './ToastifyProvider'

type Props = {
	children: ReactNode
}

export const Providers = ({ children }: Props) => {
	return (
		<>
			<Provider store={store}>
				<ToastifyProvider>
					<AuthGuard>{children}</AuthGuard>
				</ToastifyProvider>
			</Provider>
		</>
	)
}
